#!/bin/csh

nmrPipe -in test.fid \
| nmrPipe  -fn SOL                                    \
| nmrPipe  -fn COADD -axis Y -cList 1.0 0.0 -time              \
| nmrPipe -fn MAC -macro $NMRTXT/bruk_ranceY.M -noRd -noWr     \
| nmrPipe  -fn SP -off 0.5 -end 0.98 -pow 2 -c 0.5    \
| nmrPipe  -fn ZF -zf 2                               \
| nmrPipe  -fn FT                                     \
| nmrPipe  -fn PS -p0 -124.0 -p1 0.0 -di                 \
| nmrPipe  -fn EXT -xn 6.0ppm -sw -verb               \
| nmrPipe  -fn TP                                     \
| nmrPipe  -fn SP -off 0.5 -end 0.98 -pow 2 -c 0.5    \
| nmrPipe  -fn ZF -zf 2                               \
| nmrPipe  -fn FT -auto                               \
| nmrPipe  -fn PS -p0 90.0 -p1 0.0 -di                 \
| nmrPipe  -fn TP                                     \
| nmrPipe  -fn POLY -auto -window 16       \
| nmrPipe  -fn EXT -x1 9.5ppm -sw         \
   -verb -ov -out test1.ft2

nmrPipe -in test1.ft2 \
|pipe2xyz -nv -out test1.nv

nmrPipe -in test.fid \
| nmrPipe  -fn SOL                                    \
| nmrPipe  -fn COADD -axis Y -cList 0.0 1.0 -time              \
| nmrPipe -fn MAC -macro $NMRTXT/bruk_ranceY.M -noRd -noWr     \
| nmrPipe  -fn SP -off 0.5 -end 0.98 -pow 2 -c 0.5    \
| nmrPipe  -fn ZF -zf 2                               \
| nmrPipe  -fn FT                                     \
| nmrPipe  -fn PS -p0 -124.0 -p1 0.0 -di                 \
| nmrPipe  -fn EXT -xn 6.0ppm -sw -verb               \
| nmrPipe  -fn TP                                     \
| nmrPipe  -fn SP -off 0.5 -end 0.98 -pow 2 -c 0.5    \
| nmrPipe  -fn ZF -zf 2                               \
| nmrPipe  -fn FT -auto                               \
| nmrPipe  -fn PS -p0 90.0 -p1 0.0 -di                 \
| nmrPipe  -fn TP                                     \
| nmrPipe  -fn POLY -auto -window 16       \
| nmrPipe  -fn EXT -x1 9.5ppm  -sw         \
   -verb -ov -out test2.ft2
nmrPipe -in test2.ft2 \
|pipe2xyz -nv -out test2.nv

